/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT MODIFY */

/*
 * schema-defined QMP->QAPI command dispatch
 *
 * Copyright IBM, Corp. 2011
 *
 * Authors:
 *  Anthony Liguori   <aliguori@us.ibm.com>
 *
 * This work is licensed under the terms of the GNU LGPL, version 2.1 or later.
 * See the COPYING.LIB file in the top-level directory.
 *
 */

#include "qemu-common.h"
#include "qemu/module.h"
#include "qapi/qmp/qerror.h"
#include "qapi/qmp/types.h"
#include "qapi/qmp/dispatch.h"
#include "qapi/visitor.h"
#include "qapi/qmp-output-visitor.h"
#include "qapi/qmp-input-visitor.h"
#include "qapi/dealloc-visitor.h"
#include "qapi-types.h"
#include "qapi-visit.h"

#include "qmp-commands.h"

int qmp_marshal_input_add_client(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * protocol = NULL;
    char * fdname = NULL;
    bool has_skipauth = false;
    bool skipauth;
    bool has_tls = false;
    bool tls;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &protocol, "protocol", errp);
    visit_type_str(v, &fdname, "fdname", errp);
    visit_start_optional(v, &has_skipauth, "skipauth", errp);
    if (has_skipauth) {
        visit_type_bool(v, &skipauth, "skipauth", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_tls, "tls", errp);
    if (has_tls) {
        visit_type_bool(v, &tls, "tls", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_add_client(protocol, fdname, has_skipauth, skipauth, has_tls, tls, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &protocol, "protocol", NULL);
    visit_type_str(v, &fdname, "fdname", NULL);
    visit_start_optional(v, &has_skipauth, "skipauth", NULL);
    if (has_skipauth) {
        visit_type_bool(v, &skipauth, "skipauth", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_tls, "tls", NULL);
    if (has_tls) {
        visit_type_bool(v, &tls, "tls", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_name(NameInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_NameInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_NameInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_name(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    NameInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_name(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_name(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_version(VersionInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_VersionInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_VersionInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_version(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    VersionInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_version(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_version(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_kvm(KvmInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_KvmInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_KvmInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_kvm(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    KvmInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_kvm(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_kvm(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_status(StatusInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_StatusInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_StatusInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_status(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    StatusInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_status(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_status(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_uuid(UuidInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_UuidInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_UuidInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_uuid(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    UuidInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_uuid(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_uuid(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_chardev(ChardevInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_ChardevInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_ChardevInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_chardev(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    ChardevInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_chardev(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_chardev(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_ringbuf_write(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * data = NULL;
    bool has_format = false;
    DataFormat format;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &data, "data", errp);
    visit_start_optional(v, &has_format, "format", errp);
    if (has_format) {
        visit_type_DataFormat(v, &format, "format", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_ringbuf_write(device, data, has_format, format, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &data, "data", NULL);
    visit_start_optional(v, &has_format, "format", NULL);
    if (has_format) {
        visit_type_DataFormat(v, &format, "format", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_ringbuf_read(char * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_str(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_ringbuf_read(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    char * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    int64_t size;
    bool has_format = false;
    DataFormat format;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_int(v, &size, "size", errp);
    visit_start_optional(v, &has_format, "format", errp);
    if (has_format) {
        visit_type_DataFormat(v, &format, "format", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_ringbuf_read(device, size, has_format, format, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_ringbuf_read(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_int(v, &size, "size", NULL);
    visit_start_optional(v, &has_format, "format", NULL);
    if (has_format) {
        visit_type_DataFormat(v, &format, "format", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_commands(CommandInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_CommandInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_CommandInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_commands(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    CommandInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_commands(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_commands(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_events(EventInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_EventInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_EventInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_events(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    EventInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_events(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_events(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_migrate(MigrationInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_MigrationInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_MigrationInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_migrate(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    MigrationInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_migrate(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_migrate(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_migrate_set_capabilities(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    MigrationCapabilityStatusList * capabilities = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_MigrationCapabilityStatusList(v, &capabilities, "capabilities", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_migrate_set_capabilities(capabilities, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_MigrationCapabilityStatusList(v, &capabilities, "capabilities", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_migrate_capabilities(MigrationCapabilityStatusList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_MigrationCapabilityStatusList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_MigrationCapabilityStatusList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_migrate_capabilities(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    MigrationCapabilityStatusList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_migrate_capabilities(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_migrate_capabilities(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_mice(MouseInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_MouseInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_MouseInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_mice(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    MouseInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_mice(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_mice(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_cpus(CpuInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_CpuInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_CpuInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_cpus(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    CpuInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_cpus(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_cpus(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_block(BlockInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_BlockInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_BlockInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_block(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    BlockInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_block(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_block(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_blockstats(BlockStatsList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_BlockStatsList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_BlockStatsList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_blockstats(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    BlockStatsList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_blockstats(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_blockstats(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_vnc(VncInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_VncInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_VncInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_vnc(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    VncInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_vnc(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_vnc(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_spice(SpiceInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_SpiceInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_SpiceInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_spice(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    SpiceInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_spice(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_spice(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_balloon(BalloonInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_BalloonInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_BalloonInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_balloon(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    BalloonInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_balloon(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_balloon(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_pci(PciInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_PciInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_PciInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_pci(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    PciInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_pci(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_pci(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_block_jobs(BlockJobInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_BlockJobInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_BlockJobInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_block_jobs(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    BlockJobInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_block_jobs(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_block_jobs(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_quit(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_quit(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_stop(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_stop(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_system_reset(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_system_reset(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_system_powerdown(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_system_powerdown(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_cpu(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t index;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &index, "index", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_cpu(index, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &index, "index", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_cpu_add(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t id;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &id, "id", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_cpu_add(id, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &id, "id", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_memsave(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t val;
    int64_t size;
    char * filename = NULL;
    bool has_cpu_index = false;
    int64_t cpu_index;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &val, "val", errp);
    visit_type_int(v, &size, "size", errp);
    visit_type_str(v, &filename, "filename", errp);
    visit_start_optional(v, &has_cpu_index, "cpu-index", errp);
    if (has_cpu_index) {
        visit_type_int(v, &cpu_index, "cpu-index", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_memsave(val, size, filename, has_cpu_index, cpu_index, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &val, "val", NULL);
    visit_type_int(v, &size, "size", NULL);
    visit_type_str(v, &filename, "filename", NULL);
    visit_start_optional(v, &has_cpu_index, "cpu-index", NULL);
    if (has_cpu_index) {
        visit_type_int(v, &cpu_index, "cpu-index", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_pmemsave(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t val;
    int64_t size;
    char * filename = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &val, "val", errp);
    visit_type_int(v, &size, "size", errp);
    visit_type_str(v, &filename, "filename", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_pmemsave(val, size, filename, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &val, "val", NULL);
    visit_type_int(v, &size, "size", NULL);
    visit_type_str(v, &filename, "filename", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_cont(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_cont(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_system_wakeup(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_system_wakeup(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_inject_nmi(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_inject_nmi(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_set_link(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * name = NULL;
    bool up;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &name, "name", errp);
    visit_type_bool(v, &up, "up", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_set_link(name, up, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &name, "name", NULL);
    visit_type_bool(v, &up, "up", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_passwd(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * password = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &password, "password", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_passwd(device, password, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &password, "password", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_balloon(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t value;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &value, "value", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_balloon(value, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &value, "value", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_resize(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    int64_t size;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_int(v, &size, "size", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_resize(device, size, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_int(v, &size, "size", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_transaction(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    TransactionActionList * actions = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_TransactionActionList(v, &actions, "actions", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_transaction(actions, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_TransactionActionList(v, &actions, "actions", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_blockdev_snapshot_sync(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * snapshot_file = NULL;
    bool has_format = false;
    char * format = NULL;
    bool has_mode = false;
    NewImageMode mode;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &snapshot_file, "snapshot-file", errp);
    visit_start_optional(v, &has_format, "format", errp);
    if (has_format) {
        visit_type_str(v, &format, "format", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_mode, "mode", errp);
    if (has_mode) {
        visit_type_NewImageMode(v, &mode, "mode", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_blockdev_snapshot_sync(device, snapshot_file, has_format, format, has_mode, mode, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &snapshot_file, "snapshot-file", NULL);
    visit_start_optional(v, &has_format, "format", NULL);
    if (has_format) {
        visit_type_str(v, &format, "format", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_mode, "mode", NULL);
    if (has_mode) {
        visit_type_NewImageMode(v, &mode, "mode", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_blockdev_snapshot_internal_sync(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * name = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &name, "name", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_blockdev_snapshot_internal_sync(device, name, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &name, "name", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_blockdev_snapshot_delete_internal_sync(SnapshotInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_SnapshotInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_SnapshotInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_blockdev_snapshot_delete_internal_sync(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    SnapshotInfo * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    bool has_id = false;
    char * id = NULL;
    bool has_name = false;
    char * name = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_start_optional(v, &has_id, "id", errp);
    if (has_id) {
        visit_type_str(v, &id, "id", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_name, "name", errp);
    if (has_name) {
        visit_type_str(v, &name, "name", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_blockdev_snapshot_delete_internal_sync(device, has_id, id, has_name, name, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_blockdev_snapshot_delete_internal_sync(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_start_optional(v, &has_id, "id", NULL);
    if (has_id) {
        visit_type_str(v, &id, "id", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_name, "name", NULL);
    if (has_name) {
        visit_type_str(v, &name, "name", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_human_monitor_command(char * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_str(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_human_monitor_command(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    char * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * command_line = NULL;
    bool has_cpu_index = false;
    int64_t cpu_index;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &command_line, "command-line", errp);
    visit_start_optional(v, &has_cpu_index, "cpu-index", errp);
    if (has_cpu_index) {
        visit_type_int(v, &cpu_index, "cpu-index", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_human_monitor_command(command_line, has_cpu_index, cpu_index, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_human_monitor_command(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &command_line, "command-line", NULL);
    visit_start_optional(v, &has_cpu_index, "cpu-index", NULL);
    if (has_cpu_index) {
        visit_type_int(v, &cpu_index, "cpu-index", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_commit(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    bool has_base = false;
    char * base = NULL;
    char * top = NULL;
    bool has_speed = false;
    int64_t speed;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_start_optional(v, &has_base, "base", errp);
    if (has_base) {
        visit_type_str(v, &base, "base", errp);
    }
    visit_end_optional(v, errp);
    visit_type_str(v, &top, "top", errp);
    visit_start_optional(v, &has_speed, "speed", errp);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_commit(device, has_base, base, top, has_speed, speed, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_start_optional(v, &has_base, "base", NULL);
    if (has_base) {
        visit_type_str(v, &base, "base", NULL);
    }
    visit_end_optional(v, NULL);
    visit_type_str(v, &top, "top", NULL);
    visit_start_optional(v, &has_speed, "speed", NULL);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_drive_backup(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * target = NULL;
    bool has_format = false;
    char * format = NULL;
    MirrorSyncMode sync;
    bool has_mode = false;
    NewImageMode mode;
    bool has_speed = false;
    int64_t speed;
    bool has_on_source_error = false;
    BlockdevOnError on_source_error;
    bool has_on_target_error = false;
    BlockdevOnError on_target_error;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &target, "target", errp);
    visit_start_optional(v, &has_format, "format", errp);
    if (has_format) {
        visit_type_str(v, &format, "format", errp);
    }
    visit_end_optional(v, errp);
    visit_type_MirrorSyncMode(v, &sync, "sync", errp);
    visit_start_optional(v, &has_mode, "mode", errp);
    if (has_mode) {
        visit_type_NewImageMode(v, &mode, "mode", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_speed, "speed", errp);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_on_source_error, "on-source-error", errp);
    if (has_on_source_error) {
        visit_type_BlockdevOnError(v, &on_source_error, "on-source-error", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_on_target_error, "on-target-error", errp);
    if (has_on_target_error) {
        visit_type_BlockdevOnError(v, &on_target_error, "on-target-error", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_drive_backup(device, target, has_format, format, sync, has_mode, mode, has_speed, speed, has_on_source_error, on_source_error, has_on_target_error, on_target_error, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &target, "target", NULL);
    visit_start_optional(v, &has_format, "format", NULL);
    if (has_format) {
        visit_type_str(v, &format, "format", NULL);
    }
    visit_end_optional(v, NULL);
    visit_type_MirrorSyncMode(v, &sync, "sync", NULL);
    visit_start_optional(v, &has_mode, "mode", NULL);
    if (has_mode) {
        visit_type_NewImageMode(v, &mode, "mode", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_speed, "speed", NULL);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_on_source_error, "on-source-error", NULL);
    if (has_on_source_error) {
        visit_type_BlockdevOnError(v, &on_source_error, "on-source-error", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_on_target_error, "on-target-error", NULL);
    if (has_on_target_error) {
        visit_type_BlockdevOnError(v, &on_target_error, "on-target-error", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_drive_mirror(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * target = NULL;
    bool has_format = false;
    char * format = NULL;
    MirrorSyncMode sync;
    bool has_mode = false;
    NewImageMode mode;
    bool has_speed = false;
    int64_t speed;
    bool has_granularity = false;
    uint32_t granularity;
    bool has_buf_size = false;
    int64_t buf_size;
    bool has_on_source_error = false;
    BlockdevOnError on_source_error;
    bool has_on_target_error = false;
    BlockdevOnError on_target_error;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &target, "target", errp);
    visit_start_optional(v, &has_format, "format", errp);
    if (has_format) {
        visit_type_str(v, &format, "format", errp);
    }
    visit_end_optional(v, errp);
    visit_type_MirrorSyncMode(v, &sync, "sync", errp);
    visit_start_optional(v, &has_mode, "mode", errp);
    if (has_mode) {
        visit_type_NewImageMode(v, &mode, "mode", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_speed, "speed", errp);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_granularity, "granularity", errp);
    if (has_granularity) {
        visit_type_uint32(v, &granularity, "granularity", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_buf_size, "buf-size", errp);
    if (has_buf_size) {
        visit_type_int(v, &buf_size, "buf-size", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_on_source_error, "on-source-error", errp);
    if (has_on_source_error) {
        visit_type_BlockdevOnError(v, &on_source_error, "on-source-error", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_on_target_error, "on-target-error", errp);
    if (has_on_target_error) {
        visit_type_BlockdevOnError(v, &on_target_error, "on-target-error", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_drive_mirror(device, target, has_format, format, sync, has_mode, mode, has_speed, speed, has_granularity, granularity, has_buf_size, buf_size, has_on_source_error, on_source_error, has_on_target_error, on_target_error, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &target, "target", NULL);
    visit_start_optional(v, &has_format, "format", NULL);
    if (has_format) {
        visit_type_str(v, &format, "format", NULL);
    }
    visit_end_optional(v, NULL);
    visit_type_MirrorSyncMode(v, &sync, "sync", NULL);
    visit_start_optional(v, &has_mode, "mode", NULL);
    if (has_mode) {
        visit_type_NewImageMode(v, &mode, "mode", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_speed, "speed", NULL);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_granularity, "granularity", NULL);
    if (has_granularity) {
        visit_type_uint32(v, &granularity, "granularity", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_buf_size, "buf-size", NULL);
    if (has_buf_size) {
        visit_type_int(v, &buf_size, "buf-size", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_on_source_error, "on-source-error", NULL);
    if (has_on_source_error) {
        visit_type_BlockdevOnError(v, &on_source_error, "on-source-error", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_on_target_error, "on-target-error", NULL);
    if (has_on_target_error) {
        visit_type_BlockdevOnError(v, &on_target_error, "on-target-error", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_migrate_cancel(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_migrate_cancel(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_migrate_set_downtime(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    double value;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_number(v, &value, "value", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_migrate_set_downtime(value, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_number(v, &value, "value", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_migrate_set_speed(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t value;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &value, "value", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_migrate_set_speed(value, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &value, "value", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_migrate_set_cache_size(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t value;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &value, "value", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_migrate_set_cache_size(value, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &value, "value", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_migrate_cache_size(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_migrate_cache_size(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    int64_t retval;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_migrate_cache_size(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_migrate_cache_size(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_qom_list(ObjectPropertyInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_ObjectPropertyInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_ObjectPropertyInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_qom_list(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    ObjectPropertyInfoList * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * path = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &path, "path", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_qom_list(path, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_qom_list(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &path, "path", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_set_password(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * protocol = NULL;
    char * password = NULL;
    bool has_connected = false;
    char * connected = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &protocol, "protocol", errp);
    visit_type_str(v, &password, "password", errp);
    visit_start_optional(v, &has_connected, "connected", errp);
    if (has_connected) {
        visit_type_str(v, &connected, "connected", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_set_password(protocol, password, has_connected, connected, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &protocol, "protocol", NULL);
    visit_type_str(v, &password, "password", NULL);
    visit_start_optional(v, &has_connected, "connected", NULL);
    if (has_connected) {
        visit_type_str(v, &connected, "connected", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_expire_password(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * protocol = NULL;
    char * time = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &protocol, "protocol", errp);
    visit_type_str(v, &time, "time", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_expire_password(protocol, time, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &protocol, "protocol", NULL);
    visit_type_str(v, &time, "time", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_eject(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    bool has_force = false;
    bool force;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_start_optional(v, &has_force, "force", errp);
    if (has_force) {
        visit_type_bool(v, &force, "force", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_eject(device, has_force, force, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_start_optional(v, &has_force, "force", NULL);
    if (has_force) {
        visit_type_bool(v, &force, "force", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_change_vnc_password(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * password = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &password, "password", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_change_vnc_password(password, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &password, "password", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_change(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    char * target = NULL;
    bool has_arg = false;
    char * arg = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_str(v, &target, "target", errp);
    visit_start_optional(v, &has_arg, "arg", errp);
    if (has_arg) {
        visit_type_str(v, &arg, "arg", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_change(device, target, has_arg, arg, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_str(v, &target, "target", NULL);
    visit_start_optional(v, &has_arg, "arg", NULL);
    if (has_arg) {
        visit_type_str(v, &arg, "arg", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_set_io_throttle(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    int64_t bps;
    int64_t bps_rd;
    int64_t bps_wr;
    int64_t iops;
    int64_t iops_rd;
    int64_t iops_wr;
    bool has_bps_max = false;
    int64_t bps_max;
    bool has_bps_rd_max = false;
    int64_t bps_rd_max;
    bool has_bps_wr_max = false;
    int64_t bps_wr_max;
    bool has_iops_max = false;
    int64_t iops_max;
    bool has_iops_rd_max = false;
    int64_t iops_rd_max;
    bool has_iops_wr_max = false;
    int64_t iops_wr_max;
    bool has_iops_size = false;
    int64_t iops_size;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_int(v, &bps, "bps", errp);
    visit_type_int(v, &bps_rd, "bps_rd", errp);
    visit_type_int(v, &bps_wr, "bps_wr", errp);
    visit_type_int(v, &iops, "iops", errp);
    visit_type_int(v, &iops_rd, "iops_rd", errp);
    visit_type_int(v, &iops_wr, "iops_wr", errp);
    visit_start_optional(v, &has_bps_max, "bps_max", errp);
    if (has_bps_max) {
        visit_type_int(v, &bps_max, "bps_max", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_bps_rd_max, "bps_rd_max", errp);
    if (has_bps_rd_max) {
        visit_type_int(v, &bps_rd_max, "bps_rd_max", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_bps_wr_max, "bps_wr_max", errp);
    if (has_bps_wr_max) {
        visit_type_int(v, &bps_wr_max, "bps_wr_max", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_iops_max, "iops_max", errp);
    if (has_iops_max) {
        visit_type_int(v, &iops_max, "iops_max", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_iops_rd_max, "iops_rd_max", errp);
    if (has_iops_rd_max) {
        visit_type_int(v, &iops_rd_max, "iops_rd_max", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_iops_wr_max, "iops_wr_max", errp);
    if (has_iops_wr_max) {
        visit_type_int(v, &iops_wr_max, "iops_wr_max", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_iops_size, "iops_size", errp);
    if (has_iops_size) {
        visit_type_int(v, &iops_size, "iops_size", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_set_io_throttle(device, bps, bps_rd, bps_wr, iops, iops_rd, iops_wr, has_bps_max, bps_max, has_bps_rd_max, bps_rd_max, has_bps_wr_max, bps_wr_max, has_iops_max, iops_max, has_iops_rd_max, iops_rd_max, has_iops_wr_max, iops_wr_max, has_iops_size, iops_size, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_int(v, &bps, "bps", NULL);
    visit_type_int(v, &bps_rd, "bps_rd", NULL);
    visit_type_int(v, &bps_wr, "bps_wr", NULL);
    visit_type_int(v, &iops, "iops", NULL);
    visit_type_int(v, &iops_rd, "iops_rd", NULL);
    visit_type_int(v, &iops_wr, "iops_wr", NULL);
    visit_start_optional(v, &has_bps_max, "bps_max", NULL);
    if (has_bps_max) {
        visit_type_int(v, &bps_max, "bps_max", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_bps_rd_max, "bps_rd_max", NULL);
    if (has_bps_rd_max) {
        visit_type_int(v, &bps_rd_max, "bps_rd_max", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_bps_wr_max, "bps_wr_max", NULL);
    if (has_bps_wr_max) {
        visit_type_int(v, &bps_wr_max, "bps_wr_max", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_iops_max, "iops_max", NULL);
    if (has_iops_max) {
        visit_type_int(v, &iops_max, "iops_max", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_iops_rd_max, "iops_rd_max", NULL);
    if (has_iops_rd_max) {
        visit_type_int(v, &iops_rd_max, "iops_rd_max", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_iops_wr_max, "iops_wr_max", NULL);
    if (has_iops_wr_max) {
        visit_type_int(v, &iops_wr_max, "iops_wr_max", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_iops_size, "iops_size", NULL);
    if (has_iops_size) {
        visit_type_int(v, &iops_size, "iops_size", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_stream(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    bool has_base = false;
    char * base = NULL;
    bool has_speed = false;
    int64_t speed;
    bool has_on_error = false;
    BlockdevOnError on_error;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_start_optional(v, &has_base, "base", errp);
    if (has_base) {
        visit_type_str(v, &base, "base", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_speed, "speed", errp);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_on_error, "on-error", errp);
    if (has_on_error) {
        visit_type_BlockdevOnError(v, &on_error, "on-error", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_stream(device, has_base, base, has_speed, speed, has_on_error, on_error, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_start_optional(v, &has_base, "base", NULL);
    if (has_base) {
        visit_type_str(v, &base, "base", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_speed, "speed", NULL);
    if (has_speed) {
        visit_type_int(v, &speed, "speed", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_on_error, "on-error", NULL);
    if (has_on_error) {
        visit_type_BlockdevOnError(v, &on_error, "on-error", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_job_set_speed(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    int64_t speed;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_type_int(v, &speed, "speed", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_job_set_speed(device, speed, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_type_int(v, &speed, "speed", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_job_cancel(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    bool has_force = false;
    bool force;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_start_optional(v, &has_force, "force", errp);
    if (has_force) {
        visit_type_bool(v, &force, "force", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_job_cancel(device, has_force, force, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_start_optional(v, &has_force, "force", NULL);
    if (has_force) {
        visit_type_bool(v, &force, "force", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_job_pause(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_job_pause(device, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_job_resume(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_job_resume(device, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_block_job_complete(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_block_job_complete(device, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_qom_list_types(ObjectTypeInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_ObjectTypeInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_ObjectTypeInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_qom_list_types(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    ObjectTypeInfoList * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool has_implements = false;
    char * implements = NULL;
    bool has_abstract = false;
    bool abstract;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_start_optional(v, &has_implements, "implements", errp);
    if (has_implements) {
        visit_type_str(v, &implements, "implements", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_abstract, "abstract", errp);
    if (has_abstract) {
        visit_type_bool(v, &abstract, "abstract", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_qom_list_types(has_implements, implements, has_abstract, abstract, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_qom_list_types(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_start_optional(v, &has_implements, "implements", NULL);
    if (has_implements) {
        visit_type_str(v, &implements, "implements", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_abstract, "abstract", NULL);
    if (has_abstract) {
        visit_type_bool(v, &abstract, "abstract", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_device_list_properties(DevicePropertyInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_DevicePropertyInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_DevicePropertyInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_device_list_properties(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    DevicePropertyInfoList * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * q_typename = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &q_typename, "typename", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_device_list_properties(q_typename, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_device_list_properties(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &q_typename, "typename", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_migrate(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * uri = NULL;
    bool has_blk = false;
    bool blk;
    bool has_inc = false;
    bool inc;
    bool has_detach = false;
    bool detach;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &uri, "uri", errp);
    visit_start_optional(v, &has_blk, "blk", errp);
    if (has_blk) {
        visit_type_bool(v, &blk, "blk", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_inc, "inc", errp);
    if (has_inc) {
        visit_type_bool(v, &inc, "inc", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_detach, "detach", errp);
    if (has_detach) {
        visit_type_bool(v, &detach, "detach", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_migrate(uri, has_blk, blk, has_inc, inc, has_detach, detach, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &uri, "uri", NULL);
    visit_start_optional(v, &has_blk, "blk", NULL);
    if (has_blk) {
        visit_type_bool(v, &blk, "blk", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_inc, "inc", NULL);
    if (has_inc) {
        visit_type_bool(v, &inc, "inc", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_detach, "detach", NULL);
    if (has_detach) {
        visit_type_bool(v, &detach, "detach", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_xen_save_devices_state(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * filename = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &filename, "filename", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_xen_save_devices_state(filename, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &filename, "filename", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_xen_set_global_dirty_log(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool enable;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_bool(v, &enable, "enable", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_xen_set_global_dirty_log(enable, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_bool(v, &enable, "enable", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_device_del(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * id = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &id, "id", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_device_del(id, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &id, "id", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_dump_guest_memory(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool paging;
    char * protocol = NULL;
    bool has_begin = false;
    int64_t begin;
    bool has_length = false;
    int64_t length;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_bool(v, &paging, "paging", errp);
    visit_type_str(v, &protocol, "protocol", errp);
    visit_start_optional(v, &has_begin, "begin", errp);
    if (has_begin) {
        visit_type_int(v, &begin, "begin", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_length, "length", errp);
    if (has_length) {
        visit_type_int(v, &length, "length", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_dump_guest_memory(paging, protocol, has_begin, begin, has_length, length, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_bool(v, &paging, "paging", NULL);
    visit_type_str(v, &protocol, "protocol", NULL);
    visit_start_optional(v, &has_begin, "begin", NULL);
    if (has_begin) {
        visit_type_int(v, &begin, "begin", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_length, "length", NULL);
    if (has_length) {
        visit_type_int(v, &length, "length", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_netdev_del(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * id = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &id, "id", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_netdev_del(id, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &id, "id", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_getfd(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * fdname = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &fdname, "fdname", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_getfd(fdname, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &fdname, "fdname", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_closefd(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * fdname = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &fdname, "fdname", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_closefd(fdname, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &fdname, "fdname", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_machines(MachineInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_MachineInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_MachineInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_machines(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    MachineInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_machines(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_machines(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_cpu_definitions(CpuDefinitionInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_CpuDefinitionInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_CpuDefinitionInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_cpu_definitions(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    CpuDefinitionInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_cpu_definitions(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_cpu_definitions(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_add_fd(AddfdInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_AddfdInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_AddfdInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_add_fd(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    AddfdInfo * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool has_fdset_id = false;
    int64_t fdset_id;
    bool has_opaque = false;
    char * opaque = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_start_optional(v, &has_fdset_id, "fdset-id", errp);
    if (has_fdset_id) {
        visit_type_int(v, &fdset_id, "fdset-id", errp);
    }
    visit_end_optional(v, errp);
    visit_start_optional(v, &has_opaque, "opaque", errp);
    if (has_opaque) {
        visit_type_str(v, &opaque, "opaque", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_add_fd(has_fdset_id, fdset_id, has_opaque, opaque, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_add_fd(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_start_optional(v, &has_fdset_id, "fdset-id", NULL);
    if (has_fdset_id) {
        visit_type_int(v, &fdset_id, "fdset-id", NULL);
    }
    visit_end_optional(v, NULL);
    visit_start_optional(v, &has_opaque, "opaque", NULL);
    if (has_opaque) {
        visit_type_str(v, &opaque, "opaque", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_remove_fd(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t fdset_id;
    bool has_fd = false;
    int64_t fd;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &fdset_id, "fdset-id", errp);
    visit_start_optional(v, &has_fd, "fd", errp);
    if (has_fd) {
        visit_type_int(v, &fd, "fd", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_remove_fd(fdset_id, has_fd, fd, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &fdset_id, "fdset-id", NULL);
    visit_start_optional(v, &has_fd, "fd", NULL);
    if (has_fd) {
        visit_type_int(v, &fd, "fd", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_fdsets(FdsetInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_FdsetInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_FdsetInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_fdsets(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    FdsetInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_fdsets(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_fdsets(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_target(TargetInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_TargetInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_TargetInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_target(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    TargetInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_target(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_target(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_send_key(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    KeyValueList * keys = NULL;
    bool has_hold_time = false;
    int64_t hold_time;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_KeyValueList(v, &keys, "keys", errp);
    visit_start_optional(v, &has_hold_time, "hold-time", errp);
    if (has_hold_time) {
        visit_type_int(v, &hold_time, "hold-time", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_send_key(keys, has_hold_time, hold_time, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_KeyValueList(v, &keys, "keys", NULL);
    visit_start_optional(v, &has_hold_time, "hold-time", NULL);
    if (has_hold_time) {
        visit_type_int(v, &hold_time, "hold-time", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_screendump(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * filename = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &filename, "filename", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_screendump(filename, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &filename, "filename", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_nbd_server_start(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    SocketAddress * addr = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_SocketAddress(v, &addr, "addr", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_nbd_server_start(addr, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_SocketAddress(v, &addr, "addr", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_nbd_server_add(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * device = NULL;
    bool has_writable = false;
    bool writable;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &device, "device", errp);
    visit_start_optional(v, &has_writable, "writable", errp);
    if (has_writable) {
        visit_type_bool(v, &writable, "writable", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_nbd_server_add(device, has_writable, writable, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &device, "device", NULL);
    visit_start_optional(v, &has_writable, "writable", NULL);
    if (has_writable) {
        visit_type_bool(v, &writable, "writable", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_nbd_server_stop(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_nbd_server_stop(errp);

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_chardev_add(ChardevReturn * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_ChardevReturn(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_ChardevReturn(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_chardev_add(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    ChardevReturn * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * id = NULL;
    ChardevBackend * backend = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &id, "id", errp);
    visit_type_ChardevBackend(v, &backend, "backend", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_chardev_add(id, backend, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_chardev_add(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &id, "id", NULL);
    visit_type_ChardevBackend(v, &backend, "backend", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_chardev_remove(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * id = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &id, "id", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_chardev_remove(id, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &id, "id", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_tpm_models(TpmModelList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_TpmModelList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_TpmModelList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_tpm_models(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    TpmModelList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_tpm_models(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_tpm_models(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_tpm_types(TpmTypeList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_TpmTypeList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_TpmTypeList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_tpm_types(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    TpmTypeList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_tpm_types(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_tpm_types(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_tpm(TPMInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_TPMInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_TPMInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_tpm(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    TPMInfoList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_tpm(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_tpm(retval, ret, errp);
    }

out:


    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_command_line_options(CommandLineOptionInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_CommandLineOptionInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_CommandLineOptionInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_command_line_options(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    CommandLineOptionInfoList * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool has_option = false;
    char * option = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_start_optional(v, &has_option, "option", errp);
    if (has_option) {
        visit_type_str(v, &option, "option", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_command_line_options(has_option, option, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_command_line_options(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_start_optional(v, &has_option, "option", NULL);
    if (has_option) {
        visit_type_str(v, &option, "option", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

static void qmp_marshal_output_query_rx_filter(RxFilterInfoList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_RxFilterInfoList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_RxFilterInfoList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

int qmp_marshal_input_query_rx_filter(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    RxFilterInfoList * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool has_name = false;
    char * name = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_start_optional(v, &has_name, "name", errp);
    if (has_name) {
        visit_type_str(v, &name, "name", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_query_rx_filter(has_name, name, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_query_rx_filter(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_start_optional(v, &has_name, "name", NULL);
    if (has_name) {
        visit_type_str(v, &name, "name", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

int qmp_marshal_input_blockdev_add(Monitor *mon, const QDict *qdict, QObject **ret)
{
    Error *local_err = NULL;
    Error **errp = &local_err;
    QDict *args = (QDict *)qdict;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    BlockdevOptions * options = NULL;

    mi = qmp_input_visitor_new_strict(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_BlockdevOptions(v, &options, "options", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_blockdev_add(options, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_BlockdevOptions(v, &options, "options", NULL);
    qapi_dealloc_visitor_cleanup(md);

    if (local_err) {
        qerror_report_err(local_err);
        error_free(local_err);
        return -1;
    }
    return 0;
}

